/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.nio.PacketIncompleteException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class NIOJICPConnection
extends Connection {
    private static final int MAX_HEADER_SIZE = 263;
    private SelectionKey myKey;
    private SocketChannel myChannel;
    private ByteBuffer headerBuf = ByteBuffer.allocateDirect(263);
    private ByteBuffer payloadBuf;
    private byte type;
    private byte info;
    private byte sessionID;
    private String recipientID;
    private byte[] payload;
    private boolean idle = true;

    public NIOJICPConnection(SelectionKey k) {
        this.myKey = k;
        this.myChannel = (SocketChannel)k.channel();
    }

    public synchronized JICPPacket readPacket() throws IOException {
        if (this.idle) {
            this.headerBuf.clear();
            int n = this.myChannel.read(this.headerBuf);
            if (n > 0) {
                this.idle = false;
                this.headerBuf.flip();
                this.type = this.headerBuf.get();
                this.info = this.headerBuf.get();
                this.sessionID = (byte)-1;
                if ((this.info & 4) != 0) {
                    this.sessionID = this.headerBuf.get();
                }
                if ((this.info & 2) != 0) {
                    byte recipientIDLength = this.headerBuf.get();
                    byte[] bb = new byte[recipientIDLength];
                    this.headerBuf.get(bb);
                    this.recipientID = new String(bb);
                }
                if ((this.info & 8) != 0) {
                    byte b1 = this.headerBuf.get();
                    byte b2 = this.headerBuf.get();
                    int payloadLength = b2 << 8 & 0xFF00 | b1 & 0xFF;
                    byte b3 = this.headerBuf.get();
                    byte b4 = this.headerBuf.get();
                    if ((payloadLength |= b4 << 24 & 0xFF000000 | b3 << 16 & 0xFF0000) > 1000000) {
                        throw new IOException("Packet size greater than maximum allowed size. " + payloadLength);
                    }
                    this.payload = new byte[payloadLength];
                    int payloadRead = this.headerBuf.remaining();
                    int payloadUnread = payloadLength - payloadRead;
                    if (payloadRead > 0) {
                        this.headerBuf.get(this.payload, 0, payloadRead);
                    }
                    if (payloadUnread > 0) {
                        this.payloadBuf = ByteBuffer.wrap(this.payload);
                        this.payloadBuf.position(payloadRead);
                        n = this.myChannel.read(this.payloadBuf);
                        if (this.payloadBuf.remaining() > 0) {
                            if (n > 0) {
                                throw new PacketIncompleteException();
                            }
                            this.idle = true;
                            throw new EOFException("Channel closed");
                        }
                    }
                }
                return this.buildPacket();
            }
            throw new EOFException("Channel closed");
        }
        int n = this.myChannel.read(this.payloadBuf);
        if (this.payloadBuf.remaining() > 0) {
            if (n > 0) {
                throw new PacketIncompleteException();
            }
            this.idle = true;
            throw new EOFException("Channel closed");
        }
        return this.buildPacket();
    }

    private JICPPacket buildPacket() {
        JICPPacket pkt = new JICPPacket(this.type, this.info, this.recipientID, this.payload);
        pkt.setSessionID(this.sessionID);
        this.idle = true;
        this.recipientID = null;
        this.payload = null;
        this.payloadBuf = null;
        return pkt;
    }

    public int writePacket(JICPPacket pkt) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(){

            public void flush() throws IOException {
                ByteBuffer bb = ByteBuffer.wrap(this.buf, 0, this.count);
                NIOJICPConnection.this.myChannel.write(bb);
            }
        };
        int n = pkt.writeTo(os);
        os.flush();
        return n;
    }

    public void close() throws IOException {
        this.myChannel.close();
    }

    public String getRemoteHost() throws Exception {
        Socket s = this.myChannel.socket();
        InetAddress address = s.getInetAddress();
        return address.getHostAddress();
    }

    public void configureBlocking() {
        try {
            this.myKey.cancel();
            this.myChannel.configureBlocking(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

